/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;

/// <summary>
/// Static data methods and properties
/// </summary>
public class CStat
{
    /// <summary>
    /// BaseMaster property
    /// </summary>
    protected BaseMaster m_BaseMstr { set; get; }
    
    /// <summary>
    /// Constructor takes a BaseMaster
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CStat(BaseMaster BaseMstr)
	{
        this.m_BaseMstr = BaseMstr;
	}

    /// <summary>
    /// Get data collection dataset
    /// </summary>
    /// <param name="strDataCollection"></param>
    /// <returns></returns>
    public DataSet GetDataCollectionDS(string strDataCollection)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vDataCollection", strDataCollection);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_STAT.GetDataCollectionRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }
    
}